package com.lwtek.demo;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import com.lwtek.demo.databinding.ActivityInfoBinding;
import com.lwtek.demo.databinding.DialogInputBinding;
import com.lwtek.scanner.core.ScannerDevice;

public class InfoActivity extends AppCompatActivity implements View.OnClickListener {

    private ActivityInfoBinding binding;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityInfoBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        initView();
        getInfo();

        MyApplication.getDevice().onState(new ScannerDevice.StateCallback() {
            @Override
            public void onConnected() {
                Log.d("MY_DEMO", "Connected");
                runOnUiThread(() -> {
                    Toast.makeText(InfoActivity.this, "Connected", Toast.LENGTH_LONG).show();
                });
            }

            @Override
            public void onDisconnected() {
                runOnUiThread(() -> {
                    Toast.makeText(InfoActivity.this, "Disconnect", Toast.LENGTH_LONG).show();
                });
            }
        });
    }

    public void initView() {
        setSupportActionBar(binding.appbar);

        binding.paramSetting.setOnClickListener(this);
        binding.deviceFunction.setOnClickListener(this);
        binding.scanData.setOnClickListener(this);
        binding.nameSetting.setOnClickListener(this);
        binding.storageMode.setOnClickListener(this);
    }

    public void getInfo() {
        MyApplication.getDevice().getDeviceName((data, error) ->
                runOnUiThread(() -> {
                    if (data != null) binding.deviceName.setText(data);
                })
        );
        MyApplication.getDevice().getVersion((data, error) ->
                runOnUiThread(() -> {
                    if (data != null) binding.version.setText(data);
                })
        );
        MyApplication.getDevice().getBatteryLevel((data, error) ->
                runOnUiThread(() -> {
                    if (data != null) binding.batteryLevel.setText(String.format("%d%%", data));
                })
        );
    }

    public void showNameEditDialog() {
        DialogInputBinding dialogView = DialogInputBinding.inflate(getLayoutInflater());
        AlertDialog alertDialog = new AlertDialog.Builder(this).setTitle("Change name")
                .setView(dialogView.getRoot())
                .setPositiveButton("Confirm", (dialog, which) -> {
                    Log.i("LW_SCANNER_DEMO", dialogView.nameEdit.getText().toString());
                    MyApplication.getDevice().setDeviceName(dialogView.nameEdit.getText().toString());
                    dialog.cancel();
                })
                .setNegativeButton("Cancel", (dialog, which) -> {
                    dialog.cancel();
                })
                .show();
    }

    @Override
    public void onClick(View v) {
        int vid = v.getId();
        if (vid == binding.paramSetting.getId()) {
            Intent intent = new Intent(this, ParamActivity.class);
            startActivity(intent);
        } else if (vid == binding.deviceFunction.getId()) {
            Intent intent = new Intent(this, FunctionActivity.class);
            startActivity(intent);
        } else if (vid == binding.scanData.getId()) {
            Intent intent = new Intent(this, DeviceActivity.class);
            startActivity(intent);
        } else if (vid == binding.nameSetting.getId()) {
            showNameEditDialog();
        } else if (vid == binding.storageMode.getId()) {
            Intent intent = new Intent(this, StorageActivity.class);
            startActivity(intent);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.param_menu, menu);
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == R.id.refresh) {
            getInfo();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        // close means to close the connection.
        MyApplication.getDevice().onData(null);
        MyApplication.getDevice().disconnect();
    }
}